<?php
/**
 * PHP 7.4 Polyfills Loader
 * Proyecto Survision - Cargador unificado de todos los polyfills
 * 
 * Este archivo carga automáticamente todos los polyfills necesarios 
 * para la compatibilidad PHP 5.4 → 7.4 en una sola línea
 * 
 * @author  Claude Analysis System
 * @version 1.0
 * @date    2025-01-23
 */

// Directorio base de polyfills
$polyfills_dir = __DIR__;

/**
 * Lista de polyfills a cargar en orden específico
 * 
 * El orden es importante:
 * 1. mysql_polyfill - Debe cargarse antes que cualquier uso de MySQL
 * 2. mcrypt_polyfill - Para funciones de cifrado
 * 3. ereg_polyfill - Para expresiones regulares
 * 4. count_warning_handler - Debe ser último para interceptar errores
 */
$polyfills = array(
    'mysql_polyfill.php',
    'mcrypt_polyfill.php', 
    'ereg_polyfill.php',
    'count_warning_handler.php'
);

// Log de inicio
error_log("=== PHP Polyfills Loader iniciado ===");

// Cargar cada polyfill
foreach ($polyfills as $polyfill) {
    $file_path = $polyfills_dir . '/' . $polyfill;
    
    if (file_exists($file_path)) {
        require_once($file_path);
        error_log("✓ Polyfill cargado: $polyfill");
    } else {
        error_log("✗ ERROR: Polyfill no encontrado: $file_path");
        // No lanzar error fatal para evitar romper el sistema
        // en caso de archivos faltantes
    }
}

// Verificación de funciones críticas
$critical_functions = array(
    'mysql_connect' => 'MySQL Polyfill',
    'mcrypt_encrypt' => 'Mcrypt Polyfill', 
    'ereg_replace' => 'EREG Polyfill'
);

$loaded_count = 0;
foreach ($critical_functions as $function => $polyfill_name) {
    if (function_exists($function)) {
        $loaded_count++;
        error_log("✓ Función disponible: $function ($polyfill_name)");
    } else {
        error_log("✗ Función faltante: $function ($polyfill_name)");
    }
}

// Log de resultado final
error_log("=== Polyfills Loader completado: $loaded_count/" . count($critical_functions) . " funciones disponibles ===");

// Constante para verificar que el loader se ejecutó
if (!defined('SURVISION_POLYFILLS_LOADED')) {
    define('SURVISION_POLYFILLS_LOADED', true);
}

?>