<?php
/**
 * Mcrypt to OpenSSL Polyfill for PHP 7.2+ Compatibility  
 * Proyecto Survision - Reemplazo de funciones Mcrypt deprecated
 * 
 * Mcrypt fue deprecated en PHP 7.1 y eliminado en PHP 7.2
 * Este polyfill usa OpenSSL como reemplazo seguro y moderno
 * 
 * @author  Claude Analysis System
 * @version 1.0
 * @date    2025-01-23
 */

if (!function_exists('mcrypt_encrypt')) {
    
    /**
     * Cifra datos usando OpenSSL en lugar de Mcrypt
     * 
     * Mapeo de algoritmos Mcrypt → OpenSSL:
     * MCRYPT_RIJNDAEL_128 → aes-128-cbc
     * MCRYPT_RIJNDAEL_256 → aes-256-cbc  
     * MCRYPT_BLOWFISH → bf-cbc
     * 
     * @param string $cipher    Algoritmo de cifrado
     * @param string $key       Clave de cifrado
     * @param string $data      Datos a cifrar
     * @param string $mode      Modo de cifrado (ignorado, usa CBC)
     * @param string $iv        Vector de inicialización
     * @return string|false     Datos cifrados o false en error
     */
    function mcrypt_encrypt($cipher, $key, $data, $mode, $iv = null) {
        // Mapeo de algoritmos Mcrypt a OpenSSL
        $openssl_cipher = '';
        
        switch ($cipher) {
            case MCRYPT_RIJNDAEL_128:
                $openssl_cipher = 'aes-128-cbc';
                break;
            case MCRYPT_RIJNDAEL_256:  
                $openssl_cipher = 'aes-256-cbc';
                break;
            case MCRYPT_BLOWFISH:
                $openssl_cipher = 'bf-cbc';
                break;
            case MCRYPT_DES:
                $openssl_cipher = 'des-cbc';
                break;
            case MCRYPT_3DES:
                $openssl_cipher = 'des-ede3-cbc';
                break;
            default:
                // Fallback para algoritmos no mapeados
                error_log("mcrypt_encrypt: Algoritmo no soportado: $cipher");
                return false;
        }
        
        // Generar IV si no se proporciona
        if ($iv === null) {
            $iv_length = openssl_cipher_iv_length($openssl_cipher);
            $iv = openssl_random_pseudo_bytes($iv_length);
        }
        
        // Ajustar longitud de clave según algoritmo
        $key_length = openssl_cipher_iv_length($openssl_cipher);
        if (strlen($key) > $key_length) {
            $key = substr($key, 0, $key_length);
        } elseif (strlen($key) < $key_length) {
            $key = str_pad($key, $key_length, "\0");
        }
        
        return openssl_encrypt($data, $openssl_cipher, $key, OPENSSL_RAW_DATA, $iv);
    }
    
    /**
     * Descifra datos usando OpenSSL en lugar de Mcrypt
     * 
     * Reverso de mcrypt_encrypt() usando misma lógica de mapeo
     * 
     * @param string $cipher    Algoritmo de cifrado
     * @param string $key       Clave de cifrado  
     * @param string $data      Datos cifrados
     * @param string $mode      Modo de cifrado (ignorado)
     * @param string $iv        Vector de inicialización
     * @return string|false     Datos descifrados o false en error
     */
    function mcrypt_decrypt($cipher, $key, $data, $mode, $iv = null) {
        // Usar mismo mapeo que mcrypt_encrypt
        $openssl_cipher = '';
        
        switch ($cipher) {
            case MCRYPT_RIJNDAEL_128:
                $openssl_cipher = 'aes-128-cbc';
                break;
            case MCRYPT_RIJNDAEL_256:
                $openssl_cipher = 'aes-256-cbc';
                break;
            case MCRYPT_BLOWFISH:
                $openssl_cipher = 'bf-cbc';
                break;
            case MCRYPT_DES:
                $openssl_cipher = 'des-cbc';
                break;
            case MCRYPT_3DES:
                $openssl_cipher = 'des-ede3-cbc';
                break;
            default:
                error_log("mcrypt_decrypt: Algoritmo no soportado: $cipher");
                return false;
        }
        
        // Ajustar clave igual que en encrypt
        $key_length = openssl_cipher_iv_length($openssl_cipher);
        if (strlen($key) > $key_length) {
            $key = substr($key, 0, $key_length);
        } elseif (strlen($key) < $key_length) {
            $key = str_pad($key, $key_length, "\0");
        }
        
        return openssl_decrypt($data, $openssl_cipher, $key, OPENSSL_RAW_DATA, $iv);
    }
    
    /**
     * Genera vector de inicialización aleatorio
     * 
     * @param string $cipher Algoritmo de cifrado
     * @param string $mode   Modo (ignorado)
     * @return string IV aleatorio de longitud correcta
     */
    function mcrypt_create_iv($size, $source = null) {
        // OpenSSL genera bytes criptográficamente seguros
        return openssl_random_pseudo_bytes($size);
    }
    
    /**
     * Obtiene tamaño de bloque para algoritmo
     * 
     * @param string $cipher Algoritmo
     * @return int Tamaño de bloque en bytes
     */
    function mcrypt_get_block_size($cipher, $mode = null) {
        switch ($cipher) {
            case MCRYPT_RIJNDAEL_128:
                return 16;  // AES-128: 16 bytes
            case MCRYPT_RIJNDAEL_256:
                return 32;  // AES-256: 32 bytes  
            case MCRYPT_BLOWFISH:
                return 8;   // Blowfish: 8 bytes
            case MCRYPT_DES:
                return 8;   // DES: 8 bytes
            case MCRYPT_3DES:
                return 8;   // 3DES: 8 bytes
            default:
                return 16;  // Fallback seguro
        }
    }
    
    /**
     * Obtiene tamaño de clave para algoritmo
     * 
     * @param string $cipher Algoritmo
     * @return int Tamaño máximo de clave en bytes
     */
    function mcrypt_get_key_size($cipher, $mode = null) {
        switch ($cipher) {
            case MCRYPT_RIJNDAEL_128:
                return 16;  // AES-128: 16 bytes key
            case MCRYPT_RIJNDAEL_256:
                return 32;  // AES-256: 32 bytes key
            case MCRYPT_BLOWFISH:
                return 56;  // Blowfish: hasta 56 bytes
            case MCRYPT_DES:
                return 8;   // DES: 8 bytes
            case MCRYPT_3DES:
                return 24;  // 3DES: 24 bytes
            default:
                return 32;  // Fallback seguro
        }
    }
    
    // Definir constantes Mcrypt si no existen
    if (!defined('MCRYPT_RIJNDAEL_128')) {
        define('MCRYPT_RIJNDAEL_128', 'rijndael-128');
    }
    if (!defined('MCRYPT_RIJNDAEL_256')) {
        define('MCRYPT_RIJNDAEL_256', 'rijndael-256');
    }
    if (!defined('MCRYPT_BLOWFISH')) {
        define('MCRYPT_BLOWFISH', 'blowfish');
    }
    if (!defined('MCRYPT_DES')) {
        define('MCRYPT_DES', 'des');
    }
    if (!defined('MCRYPT_3DES')) {
        define('MCRYPT_3DES', '3des');
    }
    if (!defined('MCRYPT_MODE_CBC')) {
        define('MCRYPT_MODE_CBC', 'cbc');
    }
    if (!defined('MCRYPT_MODE_ECB')) {
        define('MCRYPT_MODE_ECB', 'ecb');
    }
    if (!defined('MCRYPT_RAND')) {
        define('MCRYPT_RAND', 1);
    }
    if (!defined('MCRYPT_DEV_RANDOM')) {
        define('MCRYPT_DEV_RANDOM', 2);
    }
}

// Log de inicialización
if (PHP_VERSION_ID >= 70200) {
    error_log("Mcrypt Polyfill cargado correctamente para PHP " . PHP_VERSION);
}

?>